<?php

class EWRporta_Model_History extends XenForo_Model
{
	public function getHistoryByID($historyID)
	{
		$history = $this->_getDb()->fetchRow("
			SELECT *
				FROM EWRporta_history
			WHERE history_id = ?
		", $historyID);

		if ($history['history_type'] == 'bbcode')
		{
			$bbCodeParser = new XenForo_BbCode_Parser(XenForo_BbCode_Formatter_Base::create());
			$history['HTML'] = XenForo_Helper_String::autoLinkBbCode($history['history_content']);
			$history['HTML'] = $bbCodeParser->render($history['HTML']);
		}
		else
		{
			$history['HTML'] = $history['history_content'];
		}

		$history = $this->getModelFromCache('EWRporta_Model_Parser')->parseContents($history);
		$history = $this->getModelFromCache('EWRporta_Model_Parser')->parseTemplates($history);
		$history = $this->getModelFromCache('EWRporta_Model_Parser')->parseAutolinks($history);

		return $history;
	}

	public function getHistory($page, $start, $stop)
	{
		$start = ($start - 1) * $stop;

        $history = $this->_getDb()->fetchAll("
			SELECT *
				FROM EWRporta_history
			WHERE page_id = ?
			ORDER BY history_date DESC
			LIMIT ?, ?
		", array($page['page_id'], $start, $stop));

		foreach ($history AS &$edit)
		{
			$edit['size'] = number_format(strlen($edit['history_content']));
		}

		return $history;
	}

	public function getCount($page)
	{
        $count = $this->_getDb()->fetchRow("
			SELECT COUNT(*) AS total
				FROM EWRporta_history
			WHERE page_id = ?
			GROUP BY page_id
		", $page['page_id']);

		return $count['total'];
	}

	public function getRecentHistory($start, $stop)
	{
		$start = ($start - 1) * $stop;

        $history = $this->_getDb()->fetchAll("
			SELECT *
				FROM EWRporta_history
				LEFT JOIN EWRporta_pages ON (EWRporta_pages.page_id = EWRporta_history.page_id)
			ORDER BY history_date DESC
			LIMIT ?, ?
		", array($start, $stop));

		foreach ($history AS &$edit)
		{
			$edit['size'] = number_format(strlen($edit['history_content']));
		}

		return $history;
	}

	public function getRecentCount()
	{
        $count = $this->_getDb()->fetchRow("
			SELECT COUNT(*) AS total
				FROM EWRporta_history
		");

		return $count['total'];
	}
}